//
//  Detecting_and_Probing_the_CameraAppDelegate.m
//  Detecting and Probing the Camera
//
//  Created by Vandad Nahavandipoor on 22/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Detecting_and_Probing_the_CameraAppDelegate.h"

@implementation Detecting_and_Probing_the_CameraAppDelegate

@synthesize window = _window;

- (BOOL) isCameraAvailable{
  
  return [UIImagePickerController isSourceTypeAvailable:
          UIImagePickerControllerSourceTypeCamera];
  
}

/* 1 */
//- (BOOL)            application:(UIApplication *)application
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  if ([self isCameraAvailable]){
//    NSLog(@"Kamera jest dostępna.");
//  } else {
//    NSLog(@"Kamera nie jest dostępna.");
//  }
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}

/* 2 */
- (BOOL) cameraSupportsMedia:(NSString *)paramMediaType
                  sourceType:(UIImagePickerControllerSourceType)paramSourceType{
  
  __block BOOL result = NO;
  
  if ([paramMediaType length] == 0){
    NSLog(@"Ten komponent jest nieobsługiwany.");
    return NO;
  }
  
  NSArray *availableMediaTypes = 
  [UIImagePickerController availableMediaTypesForSourceType:paramSourceType];
  
  [availableMediaTypes enumerateObjectsUsingBlock:
   ^(id obj, NSUInteger idx, BOOL *stop) {
     
     NSString *mediaType = (NSString *)obj;
     if ([mediaType isEqualToString:paramMediaType]){
       result = YES;
       *stop= YES;
     }
     
   }];
  
  return result;
  
}

- (BOOL) doesCameraSupportShootingVideos{
  
  return [self cameraSupportsMedia:(__bridge NSString *)kUTTypeMovie
                        sourceType:UIImagePickerControllerSourceTypeCamera];
  
}

- (BOOL) doesCameraSupportTakingPhotos{
  
  return [self cameraSupportsMedia:(__bridge NSString *)kUTTypeImage
                        sourceType:UIImagePickerControllerSourceTypeCamera];
  
}
//
//- (BOOL)            application:(UIApplication *)application
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//  if ([self doesCameraSupportTakingPhotos]){
//    NSLog(@"Kamera pozwala na wykonywanie zdjęć.");
//  } else {
//    NSLog(@"Kamera nie pozwala na wykonywanie zdjęć");
//  }
//  
//  if ([self doesCameraSupportShootingVideos]){
//    NSLog(@"Kamera pozwala na nagrywanie filmów.");
//  } else {
//    NSLog(@"Kamera nie pozwala na nagrywanie filmów.");
//  }
//  
//  self.window = [[UIWindow alloc] initWithFrame:
//                 [[UIScreen mainScreen] bounds]];
//  
//  self.window.backgroundColor = [UIColor whiteColor];
//  [self.window makeKeyAndVisible];
//  return YES;
//}

- (BOOL) isFrontCameraAvailable{
  
  return [UIImagePickerController 
          isCameraDeviceAvailable:UIImagePickerControllerCameraDeviceFront];
  
}

- (BOOL) isRearCameraAvailable{
  
  return [UIImagePickerController 
          isCameraDeviceAvailable:UIImagePickerControllerCameraDeviceRear];
  
}

- (BOOL) isFlashAvailableOnFrontCamera{
  
  return [UIImagePickerController isFlashAvailableForCameraDevice:
          UIImagePickerControllerCameraDeviceFront];
  
}

- (BOOL) isFlashAvailableOnRearCamera{
  
  return [UIImagePickerController isFlashAvailableForCameraDevice:
          UIImagePickerControllerCameraDeviceRear];
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  if ([self isFrontCameraAvailable]){
    NSLog(@"Przednia kamera jest dostępna.");
    if ([self isFlashAvailableOnFrontCamera]){
      NSLog(@"Przednia kamera posiada lampę błyskową");
    } else {
      NSLog(@"Przednia kamera nie posiada lampy błyskowej");
    }
  } else {
    NSLog(@"Przednia kamera nie jest dostępna.");
  }
  
  if ([self isRearCameraAvailable]){
    NSLog(@"Tylna kamera jest dostępna.");
    if ([self isFlashAvailableOnRearCamera]){
      NSLog(@"Tylna kamera posiada lampę błyskową");
    } else {
      NSLog(@"Tylna kamera nie posiada lampy błyskowej");
    }
  } else {
    NSLog(@"Tylna kamera nie jest dostępna.");
  }
  
  if ([self doesCameraSupportTakingPhotos]){
    NSLog(@"Kamera pozwala na wykonywanie zdjęć.");
  } else {
    NSLog(@"Kamera nie pozwala na wykonywanie zdjęć");
  }
  
  if ([self doesCameraSupportShootingVideos]){
    NSLog(@"Kamera pozwala na nagrywanie filmów.");
  } else {
    NSLog(@"Kamera nie pozwala na nagrywanie filmów.");
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
